libname q 'c:\SASCodeforBook\SASDataSets';
Data first; set q.houstonschools;
	/*This program estimates the Baseline + GPropensity3 + Success for All models.
	It enables the effects of SFA and GPropensity3 to be studied.  It documents the possible 
	suppressor effects of SFA and GPropensity3. Hyp.: The stronger their negative effects on
	the outcome, and the stronger these variables affect the treatment assignment,
	then the greater the enhancement of the baseline treatment effect when these variables
    are controlled.  The full covariate set weakens their effect and the enhancement
	drops off.  The propensity scores GPropensity3 appear in the dataset houstonschools*/

			
*this code transforms the school quality rating;
SQR = .;
If schoolQR = 2 then SQR = 0;
If schoolQR = 3 then SQR = 1;
if schoolQR = 4 then SQR = 2;

*This code creats the number of positive events for each school in a year;
*There is no need to use these events and trials;
RNumPositive = round(TotalSTudents*Reading/100);
WNumPositive = round(TotalStudents*G4Write/100);
MNumPositive = round(TotalStudents*Math/100);
RMNumPositive= round(TotalStudents*AveMard/100);

*Purpose: this code changes the reference category for indicator variables;

NYRCLASS = .;
IF YRCLASS = 1 THEN NYRCLASS = 0;
IF YRCLASS = 2 THEN NYRCLASS = 1;
IF YRCLASS = 3 THEN NyrcLASS = 2;

*This code creates easier to interpret variable names;
period = nyrclass;
treatment = pbldum;
stratiodep= stratio;

	/*This code standardizes the covariates to mean zero*/

        Proc standard data = first out= standard mean=0;
        var sfal gpropensity3
		femprob maleprob blackprob hispprob frrdprob stratio lep mobility; 
		
Title 'The variables standardized by their means';
        proc means data = standard;
        var SFAL gpropensity3
		femprob maleprob blackprob hispprob frrdprob stratio lep mobility; 
run;

data standard; set standard;

		/* Data for Table 12.6*/

Title 'Reading: design variable + success for all + propensity scores CS';
Proc Glimmix data = standard  method = rspl  noitprint ic=pq ;
Class school treatment period; 
Model reading/denom = treatment period treatment*period gpropensity3 sfal  
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =50;
random period / sub = school(treatment)  type = cs s residual vcorr;
run;	


Title 'Mathematics: design variable + success for all + propensity scores Toep(2)';
Proc Glimmix data = standard  method = rspl  noitprint ic=pq ;
Class school treatment period; 
Model math/denom = treatment period treatment*period gpropensity3 sfal  
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =50;
random period / sub = school(treatment)  type = toep(2) s residual vcorr;
run;


Title'Average of Reading and Math: design variable + success for all + propensity scores CS';
Proc Glimmix data = standard  method = rspl  noitprint ic=pq ;
Class school treatment period; 
Model avemard/denom = treatment period treatment*period gpropensity3 sfal  
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =50;
random period / sub = school(treatment)  type = cs s residual vcorr;
run;

Title'Fourth Grade Writing: design variable + success for all + propensity scores UN(1)';
Proc Glimmix data = standard  method = rspl  noitprint ic=pq ;
Class school treatment period; 
Model G4Write/denom = treatment period treatment*period gpropensity3 sfal  
	/ cl solution dist=binomial link=logit ;
nloptions maxiter =50;
random period / sub = school(treatment)  type = UN(1) s residual vcorr;
run;

Title ' School Quality Ratings in Proc Glimmix  design + SFA + Propensity scores';
	Proc Glimmix data = standard  method = rspl  ic=pq ;
	Class school  treatment period sqr;
	Model sqr (descending) = treatment period treatment*period gpropensity3 SFAL
					/ cl solution dist=mult link=cumlogit;
	nloptions maxiter =100;
*random period / sub = school (treatment) s  vcorr;
run;

		/*This ends the code for Table 12.6*/

		/*The syntax in this file is copyright by Robert B. Smith,  2011*/



